package cz.drg.clasificator.readers;

import cz.drg.clasificator.util.HeaderList;
import java.io.File;
import java.io.InputStream;
import java.util.zip.ZipFile;

/**
 * Interface used for input readers in the application. Implement this and map the class
 * in program setting file to create new reader/writer for the application.
 * 
 * @author Pavel Jirasek
 */
public interface InputReader {
    
    /**
     * Initializes reader before usage. This is used only in case of command line
     * execution with additional args. In case of service type execution the initialization
     * is done there.
     */
    public void initialize();
    
    /**
     * This method returns stream of data representing PMML XML file.
     * @return 
     */
    public ZipFile readPmmlInput();
    /**
     * This returns input data to be evaluated in convenient format.
     * @return 
     */
    public HeaderList readNextEntryBatch();
    
    public boolean hasNextEntryBatch();
    
    /**
     * Finalize everything that was used in the reader. Close streams, connections, etc.
     */
    public void close();
}
